<?php

declare(strict_types=1);

/*
 * This file is part of the RegexParser package.
 *
 * (c) Younes ENNAJI <younes.ennaji.pro@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace RegexParser\Cache;

interface CacheInterface
{
    public function generateKey(string $regex): string;

    public function write(string $key, string $content): void;

    public function load(string $key): mixed;

    public function getTimestamp(string $key): int;
}
